
package salesmansolver;

import java.util.*;

/**
 *
 * @author Andrea Barbagallo
 */
public class Chromosome {
    // A single ROUTE possible
    
    private final ArrayList<Gene> route;
    private double fitness;
    private double routeDistance;
    
    Chromosome() {
        route = new ArrayList<>();
        fitness = 0d;
    }
    
    Chromosome(Gene[] array) {
        route = new ArrayList<>();
        
        for (Gene g: array)
            route.add(g);
        
        fitness = 0d;
    }
    
    Chromosome(Chromosome another) {
        route = new ArrayList<>();
        
        for (Gene g: another.route) {
            route.add(g);
        }
        
        fitness = another.getFitness();
        routeDistance = another.getRouteDistance();
    }
    
    public void add(Gene g) { route.add(g); }
    public void remove(int i) { route.remove(i); }
    public Integer size() { return route.size(); }
    public Gene get(int i) { return route.get(i); }
    public void swap(int i, int j) {
        Collections.swap(route, i, j);
    }
    
    public LinkedHashSet<Gene> subSet(int start, int end) {
        LinkedHashSet<Gene> result = new LinkedHashSet<>();
        
        for (int i = start; i <= end; i++) {
            result.add(route.get(i));
        }
        
        return result;
    }
    
    private double calculateFitness() {
        double routeDistance = 0d;
        Gene from;
        Gene to;
        
        for (int i = 0; i < route.size() - 1; i++) {
            from = route.get(i);
            to = route.get(i+1);
            
            routeDistance += from.distance(to);
        }
        
        // Go back to the starting city
        from = route.get(route.size()-1);
        to = route.get(0);
        routeDistance += from.distance(to);
        
        fitness = 1000 / routeDistance;
        this.routeDistance = routeDistance;
        
        return fitness;
    }
    
    public double getFitness() {
        return calculateFitness();
    }
    
    public double getRouteDistance() {
        return routeDistance;
    }
    
    @Override
    public String toString() {
        /*
        String result = "\n-----[ Path ]-----\n";
        
        for (int i = 0; i < route.size(); i++) {
            result += route.get(i) + "\n";
        }
        
        result += "-------[ F:" + getFitness() + " D: " + routeDistance + " ]-------\n";
        */
        //return result;
        //return getFitness() + ":" + routeDistance + "\n";
        return route.toString() + " : " + routeDistance;
    }
}
